% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{lnm_sampler}
\alias{lnm_sampler}
\title{Sample from the Logistic Normal Multinomial}
\usage{
lnm_sampler(fit, newdata = NULL, indices = NULL, ...)
}
\arguments{
\item{fit}{The fitted LNM model from which to draw posterior predictive
samples.}

\item{newdata}{A data.frame containing new inputs from which to sample
responses. If NULL, defaults to the data used to estimate fit.}

\item{indices}{The coordinates of the response from which to draw samples.}

\item{...}{Additional parameters passed to sample.}
}
\value{
y_star A data.frame of samples y associated wtih the new inputs.
}
\description{
This samples from the posterior predictive of a fitted logistic-normal
multinomial model.
}
\examples{
m <- lnm_model()
mat <- data.frame(matrix(rpois(250, 10), 25, 10))
colnames(mat) <- paste0("y", 1:6)
fit <- estimator(m)(y1 + y2 + y3 + y4 ~ y5 + y6, mat)
lnm_sampler(fit, depth = 10)
lnm_sampler(fit, depth = 100)
}
