% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_clauses.R
\name{mc_clauses}
\alias{mc_clauses}
\title{Count clauses in a multicastR table}
\usage{
mc_clauses(x, bytext = FALSE, printToConsole = FALSE)
}
\arguments{
\item{x}{A \code{\link{data.frame}} in multicastR format. This table
minimally requires the \code{corpus} and \code{graid} columns with the
names of the corpora and the GRAID annotation values, respectively, as well
as the \code{text} column if \code{bytext} is set to \code{TRUE}.}

\item{bytext}{Logical. If \code{FALSE}, calculate the number of clause units
for each corpus. If \code{TRUE}, count for each text separately.
\code{FALSE} by default.}

\item{printToConsole}{Logical. If \code{TRUE}, prints the table to the
console (using \code{\link{message}}). \code{FALSE} by default.}
}
\value{
A \code{data.frame} with the \code{corpus}, \code{text} (if
  \code{bytext} is \code{TRUE}), the number of valid clause units in each
  corpus (\code{nClause}), the total number of clause units (\code{nAll}),
  the number of clause units not analyzed (\code{nNC}), and the percentage
  the later make up of the total (\code{pNC}).
}
\description{
\code{mc_clauses} counts the number of clause units (bounded by the
\code{<##>} or \code{<#>} GRAID annotation symbols) in a multicastR table.
}
\examples{
\dontrun{
  # count clause units in the most recent version
  # of the Multi-CAST data, by corpus
  n <- mc_clauses(multicast())

  # count by text instead
  m <- mc_clauses(multicast(), bytext = TRUE)

  # number of clauses units in the whole collection
  sum(n$nClauses)
}

}
\seealso{
\code{\link{multicast}}, \code{\link{mc_index}},
  \code{\link{mc_metadata}}, \code{\link{mc_referents}},
  \code{\link{mc_clauses}}
}
