% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_int.R
\name{calc_recruitment}
\alias{calc_recruitment}
\title{Calculate recruitment from stock-recruit function}
\usage{
calc_recruitment(x, SRR = c("BH", "Ricker"), eq = FALSE, ...)
}
\arguments{
\item{x}{Numeric, either the spawning output or the equilibrium spawners per recruit, from which
the recruitment will be calculated. See argument \code{eq}.}

\item{SRR}{Character to indicate the functional form of the stock recruit function}

\item{eq}{Logical, indicates whether \code{x} is the spawning output (\code{FALSE}) or equilibrium spawners per recruit (\code{TRUE})}

\item{...}{Parameters of the SRR function. Provide one of two sets of variables:
\enumerate{
\item \code{h}, \code{R0} and \code{phi0}, or
\item \code{a} and \code{b} (alpha, beta values)
}}
}
\value{
Numeric of length \code{x}
}
\description{
Calculate recruitment from stock-recruit function
}
\examples{
calc_recruitment(10, SRR = "Ricker", a = 2, b = 0.5)
calc_recruitment(10, SRR = "Ricker", h = 0.9, R0 = 1, phi0 = 1)
}
