% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtscr_model.R
\name{mtscr_model}
\alias{mtscr_model}
\title{Create MTS model}
\usage{
mtscr_model(
  df,
  id_column,
  item_column = NULL,
  score_column,
  top = 1,
  prepared = FALSE,
  ties_method = c("random", "average"),
  normalise = TRUE,
  self_ranking = NULL
)
}
\arguments{
\item{df}{Data frame in long format.}

\item{id_column}{Name of the column containing participants' id.}

\item{item_column}{Optional, name of the column containing distinct trials
(e.g. names of items in AUT).}

\item{score_column}{Name of the column containing divergent thinking scores
(e.g. semantic distance).}

\item{top}{Integer or vector of integers (see examples), number of top answers
to include in the model. Default is 1, i.e. only the top answer.}

\item{prepared}{Logical, is the data already prepared with \code{mtscr_prepare()}?}

\item{ties_method}{Character string specifying how ties are treated when
ordering. Can be \code{"average"} (better for continuous scores like semantic
distance) or \code{"random"} (default, better for ratings). See \code{\link[=rank]{rank()}} for details.}

\item{normalise}{Logical, should the creativity score be normalised? Default is \code{TRUE} and
it's recommended to leave it as such.}

\item{self_ranking}{Name of the column containing answers' self-ranking.
Provide if model should be based on top answers self-chosen by the participant.
Every item should have its own ranks. The top answers should have a value of 1,
and the other answers should have a value of 0. In that case, the \code{top} argument
doesn't change anything and should be left as \code{top = 1}. \code{ties_method} is not used if \code{self_ranking}
was provided. See \link{mtscr_self_rank} for example.}
}
\value{
The return value depends on length of the \code{top} argument. If \code{top} is a single
integer, a \code{glmmTMB} model is returned. If \code{top} is a vector of integers, a list
of \code{glmmTMB} models is returned, with names corresponding to the \code{top} values,
e.g. \code{top1}, \code{top2}, etc.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function was deprecated in favour of \code{\link[=mtscr]{mtscr()}}.

Create MTS model for creativity analysis.
}
\examples{
\dontrun{
data("mtscr_creativity", package = "mtscr")

mtscr_creativity <- mtscr_creativity |>
  dplyr::slice_sample(n = 300) # for performance, ignore

mtscr_model(mtscr_creativity, id, item, SemDis_MEAN) |>
  summary()

# three models for top 1, 2, and 3 answers
mtscr_model(mtscr_creativity, id, item, SemDis_MEAN, top = 1:3) |>
  mtscr_model_summary()

# you can prepare data first
data <- mtscr_prepare(mtscr_creativity, id, item, SemDis_MEAN)
mtscr_model(data, id, item, SemDis_MEAN, prepared = TRUE)

# extract effects for creativity score by hand
model <- mtscr_model(mtscr_creativity, id, item, SemDis_MEAN, top = 1)
creativity_score <- glmmTMB::ranef(model)$cond$id[, 1]
}
}
\keyword{internal}
