% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon_entropy.R
\name{joint_shannon_entropy}
\alias{joint_shannon_entropy}
\alias{joint_shannon_entropy}
\alias{joint_H}
\title{Estimation of the Joint Shannon entropy for two categorical variables.}
\usage{
joint_shannon_entropy(x, y)

joint_H(x, y)
}
\arguments{
\item{x}{A factor as the represented categorical variable.}

\item{y}{A factor as the represented categorical variable.}
}
\value{
Joint Shannon entropy estimation for variables \code{x} and \code{y}.
}
\description{
The joint Shannon entropy provides an estimation of the measure of
uncertainty between two random variables (see 
\url{https://en.wikipedia.org/wiki/Joint_entropy}).
}
\examples{
joint_shannon_entropy(factor(c(0,0,1,1)), factor(c(0,1,0,1)))
joint_shannon_entropy(factor(c('a','b','c')), factor(c('c','b','a')))
\dontrun{
joint_shannon_entropy(1)
joint_shannon_entropy(c('a','b'), c('d','e'))
}
}
\seealso{
\code{\link{shannon_entropy}} for the entropy for a
    single variable and
    \code{\link{multivar_joint_shannon_entropy}} for the entropy
    associated with more than two random variables.
}
