% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msamp.R
\name{p}
\alias{p}
\title{Calculate the probability of a single sample being contaminated}
\usage{
p(
  C,
  w,
  G,
  Sens,
  D = c("homogeneous", "heterogeneous", "localized"),
  r = NULL,
  f = NULL
)
}
\arguments{
\item{C}{suspected lot contamination (CFU/g)}

\item{w}{weight of single sample unit (g)}

\item{G}{target value to detect (CFU/g)}

\item{Sens}{sensitivity of the analytical test (\%)}

\item{D}{distribution of the bacteria in the product lot: "homogeneous", "heterogeneous", or "localized"}

\item{r}{for the heterogeneous case only, the degree of heterogeneity. r > 0}

\item{f}{for the localized case, r is further specified. 0 < f < 1}
}
\value{
A numeric value: the probability of a single sample unit being contaminated
above target level.
}
\description{
The p() function calculates the probability of a single sample unit, with weight
w, and postulated contamination, C, being contaminated above a target level, G.
}
\details{
Refer to vignette for details.
}
\examples{

#A sample of 25 grams (w=25) is collected and analyzed using an analytical
#test with sensitivity of 90\% (Sens=.9), to detect at least 5 CFU's/g (G=5).
#The suspected or postulated level of contamination in the lot is 4 CFU's/g (C=4)

#homogeneous case
p(C=4,w=25,G=5,Sens=.9,D="homogeneous",r=NULL,f=NULL)
# 0.006117884
#heterogeneous case-- dispersion, r, is postulated as 2
p(C=4,w=25,G=5,Sens=.9,D="heterogeneous",r=2,f=NULL)
# 0.2576463
#localized case -- 30\% of the lot is postulated to be contaminated
p(C=4,w=25,G=5,Sens=.9,D="localized",r=NULL,f=.3)
# 0.001835365

}
