% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{fraction_variance_explained}
\alias{fraction_variance_explained}
\title{Fraction of variance explained}
\usage{
fraction_variance_explained(C, U)
}
\arguments{
\item{C}{A matrix. The correlation or covariance matrix (p x p).}

\item{U}{A matrix. The matrix containing the r PCs (p x r).}
}
\value{
A float.
}
\description{
Computes the fraction of variance explained (variance explained normalized by the trace of the covariance/correlation matrix) by a set of PCs.
}
\examples{
library(datasets)
TestMat <- cor(datasets::mtcars)
mspcares <- mspca(TestMat, 2, c(4,4))
fraction_variance_explained(TestMat, mspcares$x_best)
}
