% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{expand.idata}
\alias{expand.idata}
\alias{expand.ev}
\alias{expand.evd}
\alias{ev_expand}
\alias{evd_expand}
\title{Create template data sets for simulation}
\usage{
expand.idata(...)

expand.ev(...)

expand.evd(...)

ev_expand(...)

evd_expand(...)
}
\arguments{
\item{...}{passed to \code{\link[=expand.grid]{expand.grid()}}.}
}
\value{
A data frame containing one row for each combination of the items
passed in \code{...}. The result always has ID set to the row number.
}
\description{
These functions expand all combinations of arguments using
\code{\link[=expand.grid]{expand.grid()}}. \code{expand.idata()} generates an \code{idata} set; the others
generate a full data set. The result always has only one row for one
individual. Use \code{expand.evd()} or \code{evd_expand()} to render NMTRAN names
(e.g. \code{AMT} or \code{CMT}) in upper case.
}
\details{
An ID column is added as if not supplied by the user. In the output data
frame, ID is always re-written as the row number.

For \code{expand.ev()}, defaults also added include \code{cmt = 1}, \code{time = 0},
\code{evid = 1}. If \code{total} is included, then \code{addl} is derived as \code{total-1}.
If \code{tinf} is included, then an infusion rate is derived for row where
\code{tinf} is greater than zero.

\code{ev_expand()} is a synonym for \code{expand.ev()} and \code{evd_expand()} is a
synonym for \code{expand.evd()}.
}
\examples{
idata <- expand.idata(CL = c(1,2,3), VC = c(10,20,30))

doses <- expand.ev(amt = c(300,100), ii = c(12,24), cmt = 1)

infusion <- expand.ev(amt = 100, tinf = 2)

}
