% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseq.R
\name{parseq_cv}
\alias{parseq_cv}
\title{Generate a sequence of parameters based on CV}
\usage{
parseq_cv(mod, ..., .cv = 30, .n = 5, .nsd = 2, .digits = NULL)
}
\arguments{
\item{mod}{a model object.}

\item{...}{model parameter names.}

\item{.cv}{a coefficient of variation used to determine
range of test parameters.}

\item{.n}{number of parameters to simulate in the sequence.}

\item{.nsd}{number of standard deviations used to determine the range.}

\item{.digits}{if \code{numeric}, the number of significant digits in the
parameter sensitivity values are set using \code{\link[base:Round]{base::signif()}}.}
}
\description{
Generate a sequence of parameters based on CV
}
\details{
\itemize{
\item \code{.cv}  is passed to \code{\link[=seq_cv]{seq_cv()}} as \code{cv}
\item \code{.n}   is passed to \code{\link[=seq_cv]{seq_cv()}} as \code{n}
\item \code{.nsd} is passed to \code{\link[=seq_cv]{seq_cv()}} as \code{nsd}
}
}
\examples{
mod <- mrgsolve::house()

mod \%>\%
  parseq_cv(CL,VC) \%>\% 
  sens_each()

}
\seealso{
\code{\link[=parseq_fct]{parseq_fct()}}, \code{\link[=parseq_range]{parseq_range()}}, \code{\link[=parseq_manual]{parseq_manual()}}
}
