% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgsim-bg.R
\name{bg_mrgsim_d}
\alias{bg_mrgsim_d}
\title{Run mrgsim in the background}
\usage{
bg_mrgsim_d(
  mod,
  data,
  nchunk = 1,
  ...,
  .locker = NULL,
  .tag = NULL,
  .format = c("fst", "feather", "parquet", "rds"),
  .wait = TRUE,
  .seed = FALSE,
  .cores = 1,
  .plan = NULL
)
}
\arguments{
\item{mod}{A model object.}

\item{data}{Data set to simulate; see \code{\link[mrgsolve:data_set]{mrgsolve::data_set()}}.}

\item{nchunk}{Number of chunks in which to split the data set; chunking will
be based on the \code{ID} column, which is required in \code{data}.}

\item{...}{Arguments passed to \code{\link[mrgsolve:mrgsim]{mrgsolve::mrgsim()}}.}

\item{.locker}{A directory for saving simulated data; use this to collect
results from several different runs in a single folder.}

\item{.tag}{A name to use for the current run; results are saved under
\code{.tag} in \code{.locker} folder.}

\item{.format}{The output format for saving simulations; using format
\code{fst} will allow saved results to be read with \code{\link[fst:write_fst]{fst::read_fst()}}; using
format \code{arrow} will allow saved results to be read with
\code{\link[arrow:open_dataset]{arrow::open_dataset()}} with \code{format = "feather"} or \code{format = "parquet"};
note that \code{fst} is installed with \code{mrgsim.parallel} but \code{arrow} may need
explicit installation.}

\item{.wait}{If \code{FALSE}, the function returns immediately; if \code{TRUE}, then
wait until the background job is finished.}

\item{.seed}{A \code{numeric} value used to set the seed for the simulation;
this is the only way to control the random number generation for your
simulation.}

\item{.cores}{The number of cores to parallelize across; pass 1 to run the
simulation sequentially.}

\item{.plan}{The name of a \code{\link[future:plan]{future::plan()}} strategy; if passed, the
parallelization will be handled by the \code{future} package.}
}
\value{
An \code{r_process} object; see \code{\link[callr:r_bg]{callr::r_bg()}}. Call \code{process$get_result()} to
get the actual result (see \code{details}). If a \code{.locker} path is supplied,
the simulated data is saved to disk and a list of file names is returned.
}
\description{
This function uses \code{\link[callr:r_bg]{callr::r_bg()}} to simulate a dataset in the background,
optionally in parallel and optionally saving the results directly to
disk in  \code{fst}, \code{arrow} or \code{rds} format. Parallelization can be mediated
by the \code{parallel} package on unix or macos or \code{future} on any os.
}
\details{
\code{\link[=bg_mrgsim_d]{bg_mrgsim_d()}} returns a \link[processx:process]{processx::process} object (follow that link to
see a list of methods). You will have to call \code{process$get_result()} to
retrieve the result. When an output \code{.locker} is not specified, simulated
data are returned; when an output \code{.locker} is specified, the path to
the \code{fst} file on disk is returned.  The \code{fst} files  should be read with
\code{\link[fst:write_fst]{fst::read_fst()}}. When the results are not saved to \code{.locker}, you will
get a single data frame when \code{nchunk} is 1 or a list of data frames when
\code{nchunk} is greater than 1. It is safest to call \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}} or
something equivalent on the result if you are expecting data frame.
}
\examples{
mod <- mrgsolve::house(delta = 24, end = 168)
data <- mrgsolve::expand.ev(
  amt = c(100, 300, 450), 
  ID = 1:100, 
  ii = 24, 
  addl = 6
)
data <- dplyr::mutate(data, dose = amt)
process <- bg_mrgsim_d(
  mod, 
  data, 
  carry_out = "dose", 
  outvars = "CP",
  .wait = TRUE
) 
process$get_result()
 
 
ds <- file.path(tempdir(), "sims")
files <- bg_mrgsim_d(
  mod, data, carry_out = "dose", 
  .wait = TRUE, 
  .locker = ds,
  .format = "fst"
)
files
sims <- internalize_fst(ds)
head(sims)
  

}
\seealso{
\code{\link[=future_mrgsim_d]{future_mrgsim_d()}}, \code{\link[=internalize_fst]{internalize_fst()}}, \code{\link[=list_fst]{list_fst()}},
\code{\link[=head_fst]{head_fst()}}, \code{\link[=setup_locker]{setup_locker()}}
}
