% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suf_stat.R
\name{smr_stat}
\alias{smr_stat}
\alias{cohist}
\alias{vec_description}
\title{Summary Statistics}
\usage{
smr_stat(Z, mrfi, family)

cohist(Z, mrfi)

vec_description(mrfi, family, C)
}
\arguments{
\item{Z}{A \code{matrix} object containing the observed MRF. \code{NA} values can be
used to create a subregion of the lattice for non-rectangular data.}

\item{mrfi}{A \code{\link[=mrfi-class]{mrfi}} object representing the
interaction structure.}

\item{family}{The family of parameter restrictions to potentials. Families
are:
\code{'onepar'}, \code{'oneeach'}, \code{'absdif'}, \code{'dif'} or \code{'free'}.
See \code{\link[=mrf2d-family]{mrf2d-familiy}}.}

\item{C}{The maximum value of the field.}
}
\value{
A numeric vector with the summarized counts.

An array representing the co-ocurrence histogram of \code{Z} in the relative
positions contained in \code{mrfi}. Each row and column corresponds a pair of values
in \verb{(0, ..., C)} and each slice corresponds to

A \code{data.frame} describing the relative position
and interaction associated with each potential in the vector
form in each row, in the same order.
}
\description{
Computes the summary count statistics of a field given an
interaction structure and a restriction family.
\itemize{
\item \code{cohist()} computes the co-ocurrence histogram.
\item \code{smr_stat()} computes the co-ocurrence histogram, then converts it into
a vector of sufficient statistics given a \code{\link[=mrf2d-family]{family}} of restrictions.
}
}
\details{
The order the summarized counts appear in the summary vector matches
the order in \code{\link[=smr_array]{smr_array()}}.
}
\examples{
smr_stat(Z_potts, mrfi(1), "onepar")
smr_stat(Z_potts, mrfi(1), "oneeach")

cohist(Z_potts, mrfi(1))

}
\seealso{
A paper with detailed description of the package can be found at
\doi{10.18637/jss.v101.i08}
}
\author{
Victor Freguglia
}
