% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmrf.R
\name{rmrf2d_mc}
\alias{rmrf2d_mc}
\title{Markov Chain sampling of MRFs for Monte-Carlo methods}
\usage{
rmrf2d_mc(
  init_Z,
  mrfi,
  theta,
  family,
  nmc = 100,
  burnin = 100,
  cycles = 4,
  verbose = interactive()
)
}
\arguments{
\item{init_Z}{One of two options:
\itemize{
\item A \code{matrix} object with the initial field configuration. Its
valuesmust be integers in \verb{\{0,...,C\}}.
\item A length 2 \code{numeric} vector with the lattice dimensions.
}}

\item{mrfi}{A \code{\link[=mrfi-class]{mrfi}} object representing the
interaction structure.}

\item{theta}{A 3-dimensional array describing potentials. Slices represent
interacting positions, rows represent pixel values and columns represent
neighbor values. As an example: \code{theta[1,3,2]} has the potential for the
pair of values 0,2 observed in the second relative position of \code{mrfi}.}

\item{family}{The family of parameter restrictions to potentials. Families
are:
\code{'onepar'}, \code{'oneeach'}, \code{'absdif'}, \code{'dif'} or \code{'free'}.
See \code{\link[=mrf2d-family]{mrf2d-familiy}}.}

\item{nmc}{Number of samples to be stored.}

\item{burnin}{Number of cycles iterated before start collecting sufficient
statistics.}

\item{cycles}{Number of cycles between collected samples.}

\item{verbose}{\code{logical} indicating whether to print iteration number or not.}
}
\value{
A matrix where each row contains the vector of sufficient statistics
for an observation.
}
\description{
Generates a Markov Chain of random fields and returns the
sufficient statistics for each of the observations.

This function automatizes the process of generating a random sample of MRFs
to be used in Monte-Carlo methods by wrapping \code{\link[=rmrf2d]{rmrf2d}}
and executing it multiple time while storing sufficient statistics instead
of the entire lattice.
}
\note{
Fixed regions and incomplete lattices are not supported.
}
\examples{
rmrf2d_mc(c(80, 80), mrfi(1), theta_potts, family = "oneeach", nmc = 8)

}
\author{
Victor Freguglia
}
