% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MinLambda.R
\name{MinLambda}
\alias{MinLambda}
\title{Numerical optimization for finding appropriate smoothing levels.}
\usage{
MinLambda(Xmu, mm, nn, nGrid, nLambda = 2, lambda, sphere = FALSE)
}
\arguments{
\item{Xmu}{Posterior mean of the input object as a vector.}

\item{mm}{Number of rows of the original input object.}

\item{nn}{Number of columns of the original input object.}

\item{nGrid}{Size of grid where objective function is evaluated (nGrid-by-nGrid).
This argument is ignorded if a sequence \code{lambda} is specified.}

\item{nLambda}{Number of lambdas to minimize over. Possible arguments: 2 (default) or 3.}

\item{lambda}{\eqn{\lambda}-sequence which is used for optimization. If nothing is provided, \cr
\code{lambda <- 10^seq(-3, 10, len = nGrid)} is used for data on a grid and \cr
\code{lambda <- 10^seq(-6, 1, len = nGrid)} is used for spherical data.}

\item{sphere}{\code{TRUE} or \code{FALSE}: Is the input object defined on a sphere?}
}
\value{
A list with 3 objects:

\code{G} Value of objective function \eqn{G}.

\code{lambda} Evaluated smoothing parameters \eqn{\lambda}.

\code{minind} Index of minimal \eqn{\lambda}'s. \code{lambda}[\code{minind}] 
    gives the minimal values.
}
\description{
Numerical optimization of an objective function \eqn{G} is carried out to find 
appropriate signal-dependent smoothing levels (\eqn{\lambda}'s). This is easier 
than visual inspection via the signal-dependent tapering function in \code{\link{TaperingPlot}}.
}
\details{
As signal-dependent tapering functions are quiet irregular, it is hard to 
find appropriate smoothing values only by visual inspection of the tapering
function plot. A more formal approach is the numerical optimization of an 
objective function. 

Optimization can be carried out with 2 or 3 smoothing parameters. As the 
smoothing parameters 0 and \eqn{\infty} are always added, this results
in a mrbsizeR analysis with 4 or 5 smoothing parameters. 

Sometimes, not all features of the input object can be extracted using the 
smoothing levels proposed by \code{MinLambda}. It might then be necessary to
include additional smoothing levels. 

\code{\link{plot.minLambda}} creates a plot of the objective function \eqn{G} 
on a grid. The minimum is indicated with a white point. The minimum values of 
the \eqn{\lambda}'s can be extracted from the output of \code{MinLambda}, 
see examples.
}
\examples{
# Artificial sample data
set.seed(987)
sampleData <- matrix(stats::rnorm(100), nrow = 10)
sampleData[4:6, 6:8] <- sampleData[4:6, 6:8] + 5

# Minimization of two lambdas on a 20-by-20-grid
minlamOut <- MinLambda(Xmu = c(sampleData), mm = 10, nn = 10, 
                       nGrid = 20, nLambda = 2)

# Minimal lambda values
minlamOut$lambda[minlamOut$minind]

}
