% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_mpms.R
\name{summarise_mpms}
\alias{summarise_mpms}
\title{Summarise Matrix Population Models}
\usage{
summarise_mpms(x)
}
\arguments{
\item{x}{A \code{compadreDB} object containing matrix population models, typically
in a format compatible with \code{matA}, \code{matU}, and \code{matF} functions.}
}
\value{
This function prints summaries of the following metrics:
\itemize{
\item \strong{lambda values:} The lambda values (dominant eigenvalues) of
the A matrices.
\item \strong{max F values:} The maximum values from the F matrices.
\item \strong{max U values:} The maximum values from the U matrices.
\item \strong{minimum non-zero U values:} The minimum non-zero values from
the U matrices.
}
}
\description{
Calculates and summarises various metrics from matrix population models
(MPMs) including dimension (= age in Leslie matrices), lambda values, maximum
fecundity values, maximum growth/survival transition probabilities, and
minimum non-zero growth/survival transition probabilities
}
\examples{
mats <- rand_lefko_set(
  n = 10, n_stages = 5, fecundity = c(0, 0, 4, 8, 10),
  archetype = 4, output = "Type1"
)

summarise_mpms(mats)
}
\seealso{
Other utility: 
\code{\link{plot_matrix}()}
}
\concept{utility}
