% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_reproduction.R
\name{model_fecundity}
\alias{model_fecundity}
\alias{model_reproduction}
\alias{model_fertility}
\title{Model reproductive output with age using set functional forms}
\usage{
model_fecundity(params, age = NULL, maturity = 0, model = "logistic")

model_reproduction(params, age = NULL, maturity = 0, model = "logistic")

model_fertility(params, age = NULL, maturity = 0, model = "logistic")
}
\arguments{
\item{params}{A numeric vector of parameters for the selected model. The
number and meaning of parameters depend on the selected model.}

\item{age}{A numeric vector representing age. For use in creation of MPMs and
life tables, these should be integers.}

\item{maturity}{A non-negative numeric value indicating the age at maturity.
Whatever model is used, the reproductive output is forced to be 0 below the
age of maturity.}

\item{model}{A character string specifying the model to use. Must be one of
"logistic", "step", "vonbertalanffy","normal" or "hadwiger".}
}
\value{
A numeric vector representing the computed reproductive output
values.
}
\description{
This function computes reproductive output (often referred to as fertility in
human demography and fecundity in population biology) based on the logistic,
step, von Bertalanffy, Hadwiger, and normal models. The logistic model
assumes that reproductive output increases sigmoidally with age from maturity
until a maximum is reached. The step model assumes that reproductive output
is zero before the age of maturity and then remains constant. The von
Bertalanffy model assumes that, after maturity, reproductive output increases
asymptotically with age until a maximum is reached. In this formulation, the
model is set up so that reproductive output is 0 at the 'age of maturity -
1', and increases from that point. The Hadwiger model, while originally
intended to model human fertility with a characteristic hump-shaped curve, is
applied here to model fecundity (actual offspring production). For all
models, the output ensures that reproductive output is zero before the age at
maturity.
}
\details{
The required parameters varies depending on the model used. The
parameters are provided as a vector and the parameters must be provided in
the order mentioned here.
\itemize{
\item Logistic: \eqn{f_x = A / (1 + exp(-k  (x - x_m)))}
\item Step: \eqn{f_x=
  \begin{cases} A, x \geq m \\ A, x <  m \end{cases}}
\item von Bertalanffy: \eqn{f_x = A  (1 - exp(-k  (x - x_0)))}
\item Normal: \eqn{f_x = A \times \exp\left(
  -\frac{1}{2}\left(\frac{x-\mu}{\sigma}\right)^{2}\,\right)}
\item Hadwiger: \eqn{f_x = \frac{ab}{C} \left (\frac{C}{x}  \right )
   ^\frac{3}{2} \exp \left \{ -b^2  \left ( \frac{C}{x}+\frac{x}{C}-2
   \right ) \right \}}
}
}
\examples{
# Compute reproductive output using the step model
model_fecundity(age = 0:20, params = c(A = 10), maturity = 2, model = "step")

# Compute reproductive output using the logistic model
model_fecundity(
  age = 0:20, params = c(A = 10, k = 0.5, x_m = 8), maturity =
    0, model = "logistic"
)

# Compute reproductive output using the von Bertalanffy model
model_fecundity(
  age = 0:20, params = c(A = 10, k = .3), maturity = 2, model =
    "vonbertalanffy"
)

# Compute reproductive output using the normal model
model_fecundity(
  age = 0:20, params = c(A = 10, mu = 4, sd = 2), maturity = 0,
  model = "normal"
)

# Compute reproductive output using the Hadwiger model
model_fecundity(
  age = 0:50, params = c(a = 0.91, b = 3.85, C = 29.78),
  maturity = 0, model = "hadwiger"
)

model_reproduction(age = 0:20, params = c(A = 10), maturity = 2, model = "step")
model_fertility(age = 0:20, params = c(A = 10), maturity = 2, model = "step")
}
\references{
Bertalanffy, L. von (1938) A quantitative theory of organic
growth (inquiries on growth laws. II). Human Biology 10:181–213.

Peristera, P. & Kostaki, A. (2007) Modeling fertility in modern
populations. Demographic Research. 16. Article 6, 141-194
\doi{10.4054/DemRes.2007.16.6}
}
\seealso{
\code{\link[=model_mortality]{model_mortality()}} to model age-specific survival using mortality
models.

Other trajectories: 
\code{\link{model_survival}()}
}
\author{
Owen Jones \href{mailto:jones@biology.sdu.dk}{jones@biology.sdu.dk}
}
\concept{trajectories}
