% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplusParallel_automation.R
\name{mplusParallel_automation}
\alias{mplusParallel_automation}
\title{Parallel automation of running Mplus models using R.}
\usage{
mplusParallel_automation(
  k,
  k.start = 1,
  data_gen = NA,
  seed = 123,
  ncores = "default",
  run = TRUE,
  useCores = TRUE,
  cores_per_analysis = "default",
  Par_plan = "cluster",
  rec = FALSE,
  results = NULL,
  multi_con = FALSE,
  con_index = c(),
  specific_sums = NULL,
  specific_params = NULL,
  item = NULL,
  params_ext = c("unstandardized"),
  modV1s = NULL,
  ops = NULL,
  modV2s = NULL,
  custom_auto = NULL,
  retry = TRUE,
  max_retry = 5,
  folder = ""
)
}
\arguments{
\item{k}{Number of replications desired.}

\item{k.start}{Defaults to 1. Specifies the replication to start on.
Useful if the simulation stopped on a specific replication and resuming without loss of work.}

\item{data_gen}{Can take either a single dataframe in the 'folder' or a data
generation function. When it is a data generation function any arguments
for data generation should be specified in this function.}

\item{seed}{Seed defaults to 123 but can be any integer. This ensures every
replication's data is generated using a different seed but is reproducible.}

\item{ncores}{Defaults to the number of cores on the machine - 1.}

\item{run}{Logical. Defaults to T. When T the Mplus models will be run. When F models will not be run and the output files will be read in only.}

\item{useCores}{Logical. When TRUE, the mplus files will be adjusted to use
the number of cores on the machine. This can speed up simulation run times.}

\item{cores_per_analysis}{Applies when \code{useCores} is TRUE. Default is \code{ncores/2}.
If you experience issues or crashes due to memory or core use, set this lower.
In testing the default will use most of a computer's CPU power but no break the simulation.}

\item{Par_plan}{Plan for parallel processing. Defaults to 'cluster'. Can take any argument from the 'future' package}

\item{rec}{Logical. Indicates if the files are in subdirectories.}

\item{results}{Indicates which results to collect. Supports summaries, parameters,
and modindicies or any named list argument output by mplus automation. When using summaries, parameters, or modindicies
mnore specific output is available.}

\item{multi_con}{Logical. Indicates whether multiple conditions are run in a singular instance. Default is F.}

\item{con_index}{A character vector. Specifies the indices for conditions to be tracked.}

\item{specific_sums}{Extracts specific output when \code{results} is 'summaries'.}

\item{specific_params}{Extracts specific parameters when \code{results} is 'parameters'.}

\item{item}{Extracts specific items when \code{results} is 'parameters'.}

\item{params_ext}{When \code{results} is 'parameters', specifies parameter type for
extraction. Can take any type but defaults to 'unstandardized'.
If you do not desire unstandardized parameters read in an output file to
determine the name of the parameters of interest and use this as the named argument.}

\item{modV1s}{Used for specific output when \code{results} is 'mod_indicies'.}

\item{ops}{Operator for \code{modV1s}, e.g., 'BY' for factor loadings.}

\item{modV2s}{Second variable for \code{modV1s}.}

\item{custom_auto}{User-defined function for running and reading in models.
Only functions that return single dataframes each run are currently supported.}

\item{retry}{Logical. Defaults to TRUE. Retries with a new seed if chi is not
returned by the model.}

\item{max_retry}{Defaults to 5. Specifies how many times a new seed should
be attempted.}

\item{folder}{User-defined path to the root folder
of where your Mplus files are located.}
}
\value{
Function returns a dataframe of all the desired parameters for each replication.
}
\description{
This function provides a parallelized automation for Mplus when using R as the data generation method. When \code{data_gen}
is specified, include any arguments from the function that need to be set in the global enviornment.
}
\examples{
\dontrun{
# Loading the package
library(mplusParallel.automation)

# Data Generation
n_people <- 500
n_items <- 12
data <- matrix(sample(1:5, n_people * n_items, replace = TRUE), ncol = n_items)

# Writing an example input file
inp_content <- "
TITLE: TEST
DATA: FILE IS exdat.csv;
VARIABLE:
  Names ARE
i1 i2 i3 i4 i5 i6 i7 i8 i9 i10 i11 i12;
USEVARIABLES ARE i1-i12;
ANALYSIS:
TYPE = GENERAL;
PROCESSORS=6;
OUTPUT:
STANDARDIZED;
MODINDICES (ALL);
MODEL:
  trait1 BY
i1 (a1)
i2 (a2)
i3 (a3)
i4 (a4)
i5 (a5)
i6 (a6);
trait2 BY
i7 (a7)
i8 (a8)
i9 (a9)
i10 (a10)
i11 (a11)
i12 (a12);
i1-i12 (e);
trait1 @ 1
trait2 @ 1
"
writeLines(inp_content, "example_model_simple.inp")

# Running the function
res <- mplusParallel_automation(k=5, data_gen = data_gen,
results = 'parameters', specific_params = c('trait1.by', 'trait2.by'), folder = 'user_defined_path')

# Clean up
removeParFolders()
}
}
