% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granger.R
\name{ms_grangertest1}
\alias{ms_grangertest1}
\title{Test for Granger Causality}
\usage{
ms_grangertest1(x, y, order = 1, na.action = stats::na.omit, ...)
}
\arguments{
\item{x}{either a bivariate series (in which case y has to be missing) or a univariate series of observations.}

\item{y}{a univariate series of observations (if x is univariate, too).}

\item{order}{number of lags (in frames).}

\item{na.action}{a function for eliminating NAs after aligning the series x and y.}

\item{...}{passed to \code{\link[lmtest:waldtest]{lmtest::waldtest()}}.}
}
\value{
Anova object
}
\description{
Faster implementation of the vector version of  \code{\link[lmtest:grangertest]{lmtest::grangertest()}}
which uses a vectorised lag operation.
}
\examples{
data(ChickEgg, package = "lmtest")
ms_grangertest1(ChickEgg, order = 3)
}
\seealso{
Other Granger Causality: 
\code{\link{autoplot.GrangerTime}()},
\code{\link{get_granger_interactions}()},
\code{\link{granger_test}()},
\code{\link{map_to_granger_test}()},
\code{\link{ms_condgrangertest}()},
\code{\link{ms_grangertest2}()},
\code{\link{plot.GrangerInteraction}()},
\code{\link{plot_influence_diagram}()}
}
\concept{Granger Causality}
