% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{argosFiltered}
\alias{argosFiltered}
\title{Data: Tracks of two great hammerhead sharks with position confidence intervals}
\format{
A data frame with 1492 rows and 8 variables:
\describe{
\item{id}{Character, shark ID.}
\item{date}{POSIXct datetime, format YYYY-MM-DD HH:MM:SS.}
\item{lon}{Decimal longitudes.}
\item{lon025}{Decimal longitudes, lower 95\% confidence interval bound.}
\item{lon975}{Decimal longitudes, upper 95\% confidence interval bound.}
\item{lat}{Decimal latitudes.}
\item{lat025}{Decimal latitudes, lower 95\% confidence interval bound.}
\item{lat975}{Decimal latitudes, upper 95\% confidence interval bound.}
}
}
\source{
\url{https://www.savingtheblue.org}
}
\usage{
data(argosFiltered)
}
\description{
Tracks of 2 great hammerhead sharks tagged in Jupiter, and The Keys, Florida, USA, in 2022 and
2023 respectively, by Saving The Blue (savingtheblue.org), filtered by argosfilter::sdafilter and
with state space model applied using aniMotum package, using scripts by Vital Heim, see
https://github.com/SimonDedman/SavingTheBlue/blob/main/R/06A_Filter_SPOT_data.R and
https://github.com/SimonDedman/SavingTheBlue/blob/main/R/06B_CTCRW_SPOT_data_usin_animotum.R .
}
\author{
Simon Dedman, \email{simondedman@gmail.com}

Vital Heim, \email{vital.heim@gmail.com}
}
\keyword{datasets}
