% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignraster.R
\name{alignraster}
\alias{alignraster}
\title{Combines region-specific group-level UD rasters into a single raster.}
\usage{
alignraster(
  folderroots = c("/myfolder/H", "/myfolder/L", "/myfolder/M"),
  foldernames = c("H", "L", "M"),
  pattern = ".asc",
  scalefolder = "Scaled",
  scaledweightedname = "All_Rasters_Scaled_Weighted",
  savefolder = tempdir(),
  format = "ascii",
  datatype = "FLT4S",
  bylayer = TRUE,
  overwrite = TRUE,
  returnObj = FALSE
)
}
\arguments{
\item{folderroots}{Character vector of locations of folder roots output by movegroup. Function
expects CRS.Rds file and a subfolder with the scaled raster.}

\item{foldernames}{Character vector names of folders corresponding to files in folderroots, i.e.
the names of the objects, arrays, regions, etc.}

\item{pattern}{For input rasters from scaleraster. Default ".asc".}

\item{scalefolder}{For input rasters from scaleraster. Default "Scaled".}

\item{scaledweightedname}{For input rasters from scaleraster. Default "All_Rasters_Scaled".}

\item{savefolder}{E.g. "/myfolder/Aligned". Single character entry of folder to save outputs, no trailing slash.}

\item{format}{Character. Output file type for raster::writeRaster param format. Default ascii,
other options have generally not worked well in SD's experience.}

\item{datatype}{Character. Data type for writing values to disk for raster::writeRaster param
datatype. Default FLT4S.}

\item{bylayer}{For raster::writeRaster param bylayer. Default TRUE.}

\item{overwrite}{For raster::writeRaster param overwrite. Default TRUE.}

\item{returnObj}{Logical. Return the scaled object to the parent environment to be assigned as an
object? Default FALSE.}
}
\value{
Region-specific group-level UD rasters that share the same spatial extent.
}
\description{
Extends the spatial extent of each area-specific group-level raster to the spatial extent shared by all rasters.
This will only be required if you have multiple individuals (e.g. different sharks) divided amongst a few discrete areas
(e.g. around different islands) and the effort (e.g. receiver coverage) is different among islands.
Not required for multiple individuals all within the same region or sampling regime.
}
\details{
When used in a movegroup pipeline, the order would be: movegroup.R, scaleraster.R,
alignraster.R if required, plotraster.R.
}
\examples{
\donttest{
# load data
data("TracksCleaned")
# loop movegroup and scaleraster through tide subsets
tide <- c("H", "M", "L")
for (i in tide) {
dir.create(file.path(tempdir(), i))
  movegroup(
    data = TracksCleaned[TracksCleaned$T.Ph == i, ],
    ID = "Shark",
    Datetime = "Datetime",
    Lat = "Lat",
    Lon = "Lon",
    savedir = file.path(tempdir(), i, "/"))
  
  scaleraster(path = file.path(tempdir(), i),
              crsloc = file.path(tempdir(), i))
}

alignraster(folderroots = file.path(tempdir(), tide),
            foldernames = tide,
            savefolder = file.path(tempdir(), "Aligned"))
}

}
\author{
Simon Dedman, \email{simondedman@gmail.com}

Maurits van Zinnicq Bergmann, \email{mauritsvzb@gmail.com}
}
