% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_meta.R
\encoding{UTF-8}
\name{run_meta_loocv}
\alias{run_meta_loocv}
\title{Running LOOCV on hierarchical model outputs}
\usage{
run_meta_loocv(
  rv,
  set_target = c("hr", "ctsd"),
  subpop = FALSE,
  trace = FALSE,
  ...
)
}
\arguments{
\item{rv}{A \code{reactiveValues} object or list containing simulation
inputs, fitted models, and (optionally) group assignments.}

\item{set_target}{Character vector specifying the target metrics.
Options are \code{"hr"} for home range area and/or \code{"ctsd"} for movement
speed. Defaults to \code{c("hr", "ctsd")}.}

\item{subpop}{Logical; if \code{TRUE}, analyzes population-level inferences
by groups (e.g., males vs. females). Requires valid group
assigments in \code{rv}.}

\item{trace}{Logical; if \code{TRUE}, prints progress and diagnostic
messages. Default is \code{FALSE}.}

\item{...}{Additional arguments for advanced control:
\describe{
\item{.only_max_m}{Logical. If \code{TRUE}, runs the meta-analysis
only at the maximum population sample size, skipping all
intermediate sample sizes.}
\item{.progress}{Integer. Displays a progress bar.}
\item{.m}{Integer. Specifies exact sample size to use. Overrides
automatic sequence generation. Accepts a single value.}
\item{.lists}{List (optional); supplies precomputed input objects,
typically created via \code{.build_meta_objects()}.}
}}
}
\value{
A data frame containing summarized simulation outputs.
}
\description{
Performs Leave-One-Out Cross-Validation (LOOCV) on hierarchical model
outputs to assess the influence of individual simulated animals on
population-level estimates. Supports analyses with or without
groups.

In each iteration, the function removes one individual, refits
the hierarchical model to the remaining dataset, and recalculates
the target population-level estimates. This process is repeated until
every individual has been excluded once.

This approach provides insight into how sensitive overall conclusions
are to specific individuals. This helps identify influential
individuals and assess robustness.
}
\examples{
if(interactive()) {
   run_meta_loocv(rv, set_target = "hr")
}

}
\author{
Inês Silva \email{i.simoes-silva@hzdr.de}
}
\keyword{internal}
