% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{to_py_graph}
\alias{to_py_graph}
\title{Translate multi-level statnet or igraph network object to Python networkx
object}
\usage{
to_py_graph(g, lvl_attr, relabel = TRUE, directed = NULL)
}
\arguments{
\item{g}{statnet or igraph network object}

\item{lvl_attr}{character vector specifying the attribute name where level
information is stored in \code{net}.}

\item{relabel}{should nodes be relabelled with statnet \code{vertex.names} or
igraph nodal attribute \code{name}}

\item{directed}{whether the graph shall be treated as a directed graph. Per
default (\code{NULL}), this is determined automatically using the structure
of the provided network object}
}
\value{
Python networkx graph object
}
\description{
The function \code{motifr::is.directed} is used to determine whether the
provided network is directed (if \code{directed = FALSE}).
}
\details{
The nodal attribute specified by \code{lvl_attr} indicates the levels of the
nodes. Values are automatically converted to integers. Levels must be
numbered starting with 0, 1, ….
}
\examples{
\dontrun{
to_py_graph(motifr::dummy_net, lvl_attr = "sesType")
}
}
