% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{skewOS}
\alias{skewOS}
\title{Skewness of Order Statistics}
\usage{
skewOS(r, n, dist = c("unif", "exp", "weibull", "tri"), ...)
}
\arguments{
\item{r}{rank(s) of the desired order statistic(s) (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{dist}{a character string specifying the name of a distribution. Supported values are:
\itemize{
  \item \code{"unif"}: Uniform distribution
  \item \code{"exp"}: Exponential distribution
  \item \code{"weibull"}: Weibull distribution
  \item \code{"tri"}: Triangular distribution
}}

\item{...}{further arguments to be passed to \code{dist}.}
}
\value{
The skewness of the \eqn{r}th order statistic.
}
\description{
This function computes the skewness of the order statistics for a given distribution.
}
\details{
The skewness of the \eqn{r}th order statistic is calculated using the formula:
\deqn{\text{Skewness}(X_{r:n}) = \text{E}(\frac{X_{r:n}-\mu_{r:n}} {\sigma_{r:n}})^3}
where \eqn{\mu_{r:n}} and \eqn{\sigma_{r:n}} are the mean and standard deviation of the \eqn{r}th order statistic, respectively.
}
\examples{
# Skewness of the 3rd order statistic for a uniform distribution
skewOS(3, 10, "unif")

}
\seealso{
\link{varOS}, \link{kurtOS}
}
