% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mo_beta}
\alias{mo_beta}
\title{Moments of Order Statistics from the Beta Distribution (Simulated)}
\usage{
mo_beta(r, n, k = 1, a, b, rep = 1e+05, seed = 42)
}
\arguments{
\item{r}{rank of the desired order statistic (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{k}{order of the moment to compute (default is \code{1}).}

\item{a, b}{non-negative parameters of the beta distribution.}

\item{rep}{number of simulations (default is \code{1e5}).}

\item{seed}{optional seed for random number generation to ensure reproducibility (default is \code{42}).}
}
\value{
The estimated \eqn{k}th moment of the \eqn{r}th order statistic from a beta distribution.
}
\description{
This function computes the moments of order statistics from the beta distribution using simulation.
}
\details{
This function estimates the \eqn{k}th moment of the \eqn{r}th order statistic in a sample of size \eqn{n}
drawn from a beta distribution with specified shape parameters. The estimation is done via
Monte Carlo simulation using the formula:

\deqn{\text{E}[X^k] \approx \frac{1}{\mathrm{rep}} \sum_{i=1}^{\mathrm{rep}} X_i^k,}
where \eqn{X_i} are the simulated order statistics from the beta distribution.

The function relies on the \code{ros()} function to generate order statistics.
}
\note{
The accuracy of the estimated moment depends on the number of simulations (\code{rep}).
The default value \code{rep = 1e5} provides a reasonable trade-off between speed and accuracy
for most practical cases. For higher order moments or when greater precision is required,
users are encouraged to increase \code{rep} (e.g. \code{1e6}).
}
\examples{
# Compute the first moment of the 2nd order statistic from Beta(3, 4) with sample size 5
mo_beta(r = 2, n = 5, k = 1, a = 3, b = 4)

# Compute the second moment with 10000 simulations
mo_beta(r = 2, n = 5, k = 2, a = 2, b = 2.5, rep = 1e4)

}
\seealso{
\link{ros} for generating random samples of order statistics.
}
