% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNE3d.R
\name{DNE3d}
\alias{DNE3d}
\title{Plot results of a DNE analysis of a surface}
\usage{
DNE3d(
  DNE_File,
  setMax = 0,
  logColors = TRUE,
  signColor = TRUE,
  concaveMute = FALSE,
  cuttingFocus = FALSE,
  main = "",
  cex = 1,
  legend = TRUE,
  widget_size_px = 768,
  scene_zoom = 1.5,
  leftOffset = 0,
  fieldofview = 0,
  title_font_size_px = 30,
  legend_magnify = 1,
  fileName = NA,
  binary = FALSE
)
}
\arguments{
\item{DNE_File}{An object that stores the output of the \code{DNE()} function}

\item{setMax}{User-defined upper range for plotting color scheme, see Details}

\item{logColors}{Logical that log transforms the color scheme}

\item{signColor}{Logical indicating whether or not to plot by concavity vs convexity. Plotting by curve orientation is the default.}

\item{concaveMute}{Logical indicating whether or not to mute the concave portion of the Dirichlet normal density coloration. Default is FALSE.}

\item{cuttingFocus}{Logical indicating whether or not to mute the concave portion and faces with Dirichlet normal density below the top quartile. Default is FALSE.}

\item{main}{String indicating plot title}

\item{cex}{Numeric setting the relative size of the legend}

\item{legend}{Logical indicating whether or not a legend should be displayed}

\item{widget_size_px}{Sets the plot size in pixels. Default is 768 and always square}

\item{scene_zoom}{Set the initial viewing window of the 3d scene. Default is 1.5}

\item{leftOffset}{Numeric between -1 and 1 setting the amount of offset for the plotted surface to the left. Larger values push surface farther to right.}

\item{fieldofview}{Passes an argument to \code{par3d()} changing the field of view (in degrees) of the resulting 3D plot}

\item{title_font_size_px}{Sets the title font size in pixels. Default is 30}

\item{legend_magnify}{Default set to 1, changes the scaling on legend.}

\item{fileName}{String indicating a name to save the plotted surface to as a *.ply file; default of 'NA' will not save a file}

\item{binary}{Logical indicating whether or not the saved surface plot should be binary, passed to \code{vcgPlyWrite()}}
}
\description{
A molaR surface plotting function.
}
\examples{
\dontrun{
DNE_output <- DNE(Tooth)
DNE3d(DNE_output)
}
}
