% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwr_func_lmer.R
\name{pwr_func_lmer}
\alias{pwr_func_lmer}
\title{Power Analysis for Clustered Data}
\usage{
pwr_func_lmer(
  betas = list(int = 0, x1 = -5, x2 = 2, x3 = 10),
  dists = list(x1 = stats::rnorm, x2 = stats::rbinom, x3 = stats::rnorm),
  distpar = list(x1 = list(mean = 0, sd = 1), x2 = list(size = 1, prob = 0.4), x3 =
    list(mean = 1, sd = 2)),
  N = 25,
  reps = 1000,
  alpha = 0.05,
  var_intr = "x1",
  grp = "ID",
  mod = paste0("out ~ x1 + x2 + x3 + (x3|", grp, ")"),
  catsmod = "out ~ x1 + x2 + x3",
  r_slope = "x1",
  r_int = "int",
  n_time = 20,
  mean_i = 0,
  var_i = 1,
  mean_s = 0,
  var_s = 1,
  cov_is = 0,
  mean_r = 0,
  var_r = 1,
  cor_mat = NULL,
  corvars = NULL,
  time_index = NULL
)
}
\arguments{
\item{betas}{Named list of true coefficient values for the fixed effects.}

\item{dists}{Named list of functions to generate random distributions for each
predictor.}

\item{distpar}{Named list of parameter lists for each distribution function in
\code{dists}.}

\item{N}{Integer specifying the number of groups.}

\item{reps}{Integer specifying the number of replications for the simulation.}

\item{alpha}{Numeric value specifying the significance level for hypothesis
testing.}

\item{var_intr}{Character string specifying the name of the variable of interest
(for power calculations).}

\item{grp}{Character string specifying the name of the grouping variable.}

\item{mod}{Formula for fitting mixed-effects model to simulated data.}

\item{catsmod}{Formula for the CATs model.}

\item{r_slope}{Character string specifying the name of the random slope variable.
This is the random slope when simulating data.}

\item{r_int}{Character string specifying the name of the random intercept.}

\item{n_time}{Integer or vector specifying the number of time points per group.
If a vector, its length must equal N.}

\item{mean_i}{Numeric value specifying the mean for the random intercept.}

\item{var_i}{Numeric value specifying the variance for the random intercept.}

\item{mean_s}{Numeric value specifying the mean for the random slope.}

\item{var_s}{Numeric value specifying the variance for the random slope.}

\item{cov_is}{Numeric value specifying the covariance between the random intercept and slope.}

\item{mean_r}{Numeric value specifying the mean for the residual error.}

\item{var_r}{Numeric value specifying the variance for the residual error.}

\item{cor_mat}{Correlation matrix for correlated predictors, if any.}

\item{corvars}{List of vectors, each vector containing names of correlated
variables.}

\item{time_index}{Either "linear" for a linear time trend, a custom function,
or a character string that evaluates to a function for
generating time values. If specified, 'time' should be
included in \code{betas} but not in \code{dists}.}
}
\value{
A dataframe summarizing the results of the power analysis, including
average coefficient estimate, rejection rate, root mean square error,
relative root mean square error, coverage probability, and average
confidence interval width for each method.
}
\description{
Conducts a power analysis for clustered data using simulation. This function
allows for comparing the performance of different estimation methods in terms
of power, rejection rate, root mean square error (RMSE), relative RMSE, coverage
probability, and average confidence interval width.
}
\examples{
# Basic usage with default parameters
pwr_func_lmer(reps = 2)

}
