% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test_statistics.R
\name{rule_of_thumb}
\alias{rule_of_thumb}
\title{rule of thumb interval for the selection of smoothing parameter b}
\usage{
rule_of_thumb(y, x)
}
\arguments{
\item{y}{a vector, the response variable.}

\item{x}{a matrix of covariates. If the intercept should be includes, the elements of the first column should be 1.}
}
\value{
c(left, right), the vector with the left and right points of the interval
}
\description{
The function will compute a data-driven interval for the Generalized Cross Validation performed later, see also Bai and Wu (2024) .
}
\examples{
param = list(d = -0.2, heter = 2, tvd = 0,
tw = 0.8, rate = 0.1, cur = 1, center = 0.3,
 ma_rate =  0, cov_tw =  0.2, cov_rate = 0.1,
 cov_center = 0.1, all_tw  = 1, cov_trend = 0.7)
data = Qct_reg(1000, param)
rule_of_thumb(data$y, data$x)
}
\references{
Bai, L., & Wu, W. (2024). Detecting long-range dependence for time-varying linear models. Bernoulli, 30(3), 2450-2474.
}
