% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MV_ise_heter_critical}
\alias{MV_ise_heter_critical}
\title{MV method}
\usage{
MV_ise_heter_critical(critical, neighbour)
}
\arguments{
\item{critical, }{a matrix of critical values}

\item{neighbour, }{integer, number of neighbours}
}
\value{
a list of results,
\itemize{
\item minp: optimal row number
\item minq: optimal column number
\item min_ise: optimal value
}
}
\description{
Selection of smoothing parameters for bootstrap tests by choosing the index minimizing the volatility of bootstrap statistics or long-run variance estimators in the neighborhood computed before.
}
\examples{
param = list(d = -0.2, heter = 2,
 tvd = 0, tw = 0.8, rate = 0.1,
 cur = 1, center = 0.3, ma_rate =  0,
 cov_tw =  0.2, cov_rate = 0.1,
 cov_center = 0.1, all_tw  = 1, cov_trend = 0.7)
n = 1000
data = Qct_reg(n, param)
p = ncol(data$x)
t = (1:n)/n
B_c = 100 ##small value for testing
Rc = array(rnorm(n*p*B_c),dim = c(p,B_c,n))
result1 = LocLinear(0.2, t, data$y, data$x)
gridm = c(3,4,5)
gridtau = c(0.2, 0.25, 0.3)
critical <- MV_critical(data$y, result1, Rc, gridm, gridtau)
mv_result = MV_ise_heter_critical(critical,  1)
m = gridm[mv_result$minp + 1]
tau_n = gridtau[mv_result$minq + 1]
}
\references{
Bai, L., & Wu, W. (2024). Difference-based covariance matrix estimation in time series nonparametric regression with application to specification tests. Biometrika, asae013.
}
