% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerAsyncSuccessiveHalving.R
\name{mlr_tuners_async_successive_halving}
\alias{mlr_tuners_async_successive_halving}
\alias{TunerAsyncSuccessiveHalving}
\title{Asynchronous Hyperparameter Tuning with Successive Halving}
\source{
Li L, Jamieson K, Rostamizadeh A, Gonina E, Ben-tzur J, Hardt M, Recht B, Talwalkar A (2020).
\dQuote{A System for Massively Parallel Hyperparameter Tuning.}
In Dhillon I, Papailiopoulos D, Sze V (eds.), \emph{Proceedings of Machine Learning and Systems}, volume 2, 230--246.
\url{https://proceedings.mlsys.org/paper_files/paper/2020/hash/a06f20b349c6cf09a6b171c71b88bbfc-Abstract.html}.
}
\description{
\code{OptimizerAsyncSuccessiveHalving} class that implements the Asynchronous Successive Halving Algorithm (ASHA).
This class implements the asynchronous version of \link{OptimizerBatchSuccessiveHalving}.
}
\section{Dictionary}{

This \link[mlr3tuning:Tuner]{mlr3tuning::Tuner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3tuning:mlr_tuners]{mlr3tuning::mlr_tuners} or with the associated sugar function \code{\link[mlr3tuning:tnr]{mlr3tuning::tnr()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{TunerAsyncSuccessiveHalving$new()
mlr_tuners$get("async_successive_halving")
tnr("async_successive_halving")
}\if{html}{\out{</div>}}
}

\section{Subsample Budget}{

If the learner lacks a natural budget parameter,
\link[mlr3pipelines:mlr_pipeops_subsample]{mlr3pipelines::PipeOpSubsample} can be applied to use the subsampling rate
as budget parameter. The resulting \link[mlr3pipelines:mlr_learners_graph]{mlr3pipelines::GraphLearner} is fitted on
small proportions of the \link[mlr3:Task]{mlr3::Task} in the first stage, and on the complete
task in last stage.
}

\section{Custom Sampler}{

Hyperband supports custom \link[paradox:Sampler]{paradox::Sampler} object for initial
configurations in each bracket.
A custom sampler may look like this (the full example is given in the
\emph{examples} section):

\if{html}{\out{<div class="sourceCode">}}\preformatted{# - beta distribution with alpha = 2 and beta = 5
# - categorical distribution with custom probabilities
sampler = SamplerJointIndep$new(list(
  Sampler1DRfun$new(params[[2]], function(n) rbeta(n, 2, 5)),
  Sampler1DCateg$new(params[[3]], prob = c(0.2, 0.3, 0.5))
))
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{eta}}{\code{numeric(1)}\cr
With every stage, the budget is increased by a factor of \code{eta} and only the best \code{1 / eta} configurations are promoted to the next stage.
Non-integer values are supported, but \code{eta} is not allowed to be less or equal to 1.}
\item{\code{sampler}}{\link[paradox:Sampler]{paradox::Sampler}\cr
Object defining how the samples of the parameter space should be drawn.
The default is uniform sampling.}
}
}

\section{Archive}{

The \link[bbotk:Archive]{bbotk::Archive} holds the following additional columns that are specific to SHA:
\itemize{
\item \code{stage} (\verb{integer(1))}\cr
Stage index. Starts counting at 0.
\item \code{asha_id} (\verb{character(1))}\cr
Unique identifier for each configuration across stages.
}
}

\section{Super classes}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{\link[mlr3tuning:TunerAsync]{mlr3tuning::TunerAsync}} -> \code{\link[mlr3tuning:TunerAsyncFromOptimizerAsync]{mlr3tuning::TunerAsyncFromOptimizerAsync}} -> \code{TunerAsyncSuccessiveHalving}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TunerAsyncSuccessiveHalving-new}{\code{TunerAsyncSuccessiveHalving$new()}}
\item \href{#method-TunerAsyncSuccessiveHalving-clone}{\code{TunerAsyncSuccessiveHalving$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-format'><code>mlr3tuning::Tuner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="help"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-help'><code>mlr3tuning::Tuner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-print'><code>mlr3tuning::Tuner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="TunerAsyncFromOptimizerAsync" data-id="optimize"><a href='../../mlr3tuning/html/TunerAsyncFromOptimizerAsync.html#method-TunerAsyncFromOptimizerAsync-optimize'><code>mlr3tuning::TunerAsyncFromOptimizerAsync$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerAsyncSuccessiveHalving-new"></a>}}
\if{latex}{\out{\hypertarget{method-TunerAsyncSuccessiveHalving-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerAsyncSuccessiveHalving$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerAsyncSuccessiveHalving-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TunerAsyncSuccessiveHalving-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerAsyncSuccessiveHalving$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
