% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContextResample.R
\name{ContextResample}
\alias{ContextResample}
\title{Resample Context}
\description{
A \link{CallbackResample} accesses and modifies data during \code{\link[=resample]{resample()}} and \code{\link[=benchmark]{benchmark()}} via the \code{ContextResample}.
See the section on fields for a list of modifiable objects.
See \code{\link[=callback_resample]{callback_resample()}} for a list of stages that access \code{ContextResample}.
}
\section{Super class}{
\code{\link[mlr3misc:Context]{mlr3misc::Context}} -> \code{ContextResample}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{task}}{(\link{Task})\cr
The task to be evaluated.
The task is unchanged during the evaluation.
The task is read-only.}

\item{\code{learner}}{(\link{Learner})\cr
The learner to be evaluated.
The learner contains the models after stage \code{on_resample_before_train}.}

\item{\code{resampling}}{\link{Resampling}\cr
The resampling strategy to be used.
The resampling is unchanged during the evaluation.
The resampling is read-only.}

\item{\code{iteration}}{(\code{integer()})\cr
The current iteration.
The iteration is read-only.}

\item{\code{pdatas}}{(List of \link{PredictionData})\cr
The prediction data.
The data is available on stage \code{on_resample_end}.}

\item{\code{data_extra}}{(list())\cr
Data saved in the \link{ResampleResult} or \link{BenchmarkResult}.
Use this field to save results.
Must be a \code{list()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ContextResample-new}{\code{ContextResample$new()}}
\item \href{#method-ContextResample-clone}{\code{ContextResample$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Context" data-id="format"><a href='../../mlr3misc/html/Context.html#method-Context-format'><code>mlr3misc::Context$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Context" data-id="print"><a href='../../mlr3misc/html/Context.html#method-Context-print'><code>mlr3misc::Context$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextResample-new"></a>}}
\if{latex}{\out{\hypertarget{method-ContextResample-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextResample$new(task, learner, resampling, iteration)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link{Task})\cr
The task to be evaluated.}

\item{\code{learner}}{(\link{Learner})\cr
The learner to be evaluated.}

\item{\code{resampling}}{(\link{Resampling})\cr
The resampling strategy to be used.}

\item{\code{iteration}}{(\code{integer()})\cr
The current iteration.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextResample-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ContextResample-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextResample$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
