% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_forecasting.R
\encoding{UTF-8}
\name{mts_forecasting}
\alias{mts_forecasting}
\title{A forecasting procedure for MTS based on lag-embedding matrices}
\usage{
mts_forecasting(X, max_lag = 1, model_caret = "lm", h = 1)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{max_lag}{The maximum lag considered to construct the lag-embedding matrices.}

\item{model_caret}{The corresponding regression model.}

\item{h}{The prediction horizon.}
}
\value{
A list containing the \eqn{h}-step ahead forecast (matrix) for each
one of the MTS.
}
\description{
\code{mts_forecasting} computes a general forecasting method for MTS based
on fitting standard regression models to lag-embedding matrices.
}
\details{
This function performs a forecasting procedure based on lag-embedding
matrices. Given a list of MTS, it returns the corresponding list of \eqn{h}-step ahead
forecasts. We assume we want to forecast a given MTS \eqn{\boldsymbol X_T}
with certain univariate components
for a given forecasting horizon \eqn{h} and a maximum number of lags \eqn{L}.
For each component, the corresponding lag-embedded matrix is constructed
by considering the past information about that component and all the remaining
ones. The selected regression model is fitted to all the constructed matrices
(considering the last column as the response variables), and the fitted models
are used to construct the \eqn{h}-step ahead forecasts in a recursive manner.
}
\examples{
predictions <- mts_forecasting(RacketSports$data[1], model_caret = 'lm', h = 1)
# Obtaining the predictions for the first series in dataset RacketSports
# by using standard linear regression and a forecasting horizon of 1
predictions <- mts_forecasting(RacketSports$data[1], model_caret = 'rf', h = 3)
# Obtaining the predictions for the first series in dataset RacketSports
# by using the random forest and a forecasting horizon of 3
}
\author{
Ángel López-Oriona, José A. Vilar
}
