#'
#' @title NATOPS
#' @description Multivariate time series (MTS) related to several Naval Air Training and Operating Procedures Standardization-type motions
#' used to control plane movements.
#' @usage data(NATOPS)
#' @format A \code{list} with two elements, which are:
#' \describe{
#' \item{\code{data}}{A list with 360 MTS.}
#' \item{\code{classes}}{A numeric vector indicating the corresponding classes associated with the elements in \code{data}.}
#' }
#' @details Each element in \code{data} is a matrix formed by 51 rows (time points) indicating time recordings and 24 columns
#' (variables) indicating sensors placed in a particular part of the body and associated with a particular coordinate.
#' The first 180 elements correspond to the training set, whereas the last 180 elements
#' correspond to the test set. The numeric vector \code{classes} is formed by integers from 1 to 6, indicating that there are 6
#' different classes in the database. Each class is associated with a separate action performed by the subjects.
#' For more information, see \insertCite{bagnall2018uea;textual}{mlmts}.
#' Run "install.packages("ueadata2", repos="https://anloor7.github.io/drat")"
#' to access this dataset and use the syntax "ueadata2::NATOPS".
#' @references{
#'
#'   \insertRef{bagnall2018uea}{mlmts}
#'
#'   \insertRef{ruiz2021great}{mlmts}
#'
#'   \insertRef{bagnallweb}{mlmts}
#'
#' }
"NATOPS"

