% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_nd_nq.R
\name{set_nd_nq}
\alias{set_nd_nq}
\alias{set_nd_nq_focus}
\title{Set non-detects and unquantified values in residue series without replicates}
\usage{
set_nd_nq(res_raw, lod, loq = NA, time_zero_presence = FALSE)

set_nd_nq_focus(
  res_raw,
  lod,
  loq = NA,
  set_first_sample_nd = TRUE,
  first_sample_nd_value = 0,
  ignore_below_loq_after_first_nd = TRUE
)
}
\arguments{
\item{res_raw}{Character vector of a residue time series, or matrix of
residue values with rows representing depth profiles for a specific sampling
time, and columns representing time series of residues at the same depth.
Values below the limit of detection (lod) have to be coded as "nd", values
between the limit of detection and the limit of quantification, if any, have
to be coded as "nq". Samples not analysed have to be coded as "na". All
values that are not "na", "nd" or "nq" have to be coercible to numeric}

\item{lod}{Limit of detection (numeric)}

\item{loq}{Limit of quantification(numeric). Must be specified if the FOCUS rule to
stop after the first non-detection is to be applied}

\item{time_zero_presence}{Do we assume that residues occur at time zero?
This only affects samples from the first sampling time that have been
reported as "nd" (not detected).}

\item{set_first_sample_nd}{Should the first sample be set to "first_sample_nd_value"
in case it is a non-detection?}

\item{first_sample_nd_value}{Value to be used for the first sample if it is a non-detection}

\item{ignore_below_loq_after_first_nd}{Should we ignore values below the LOQ after the first
non-detection that occurs after the quantified values?}
}
\value{
A numeric vector, if a vector was supplied, or a numeric matrix otherwise
}
\description{
This function automates replacing unquantified values in residue time and
depth series. For time series, the function performs part of the residue
processing proposed in the FOCUS kinetics guidance for parent compounds
and metabolites. For two-dimensional residue series over time and depth,
it automates the proposal of Boesten et al (2015).
}
\section{Functions}{
\itemize{
\item \code{set_nd_nq_focus()}: Set non-detects in residue time series according to FOCUS rules

}}
\examples{
# FOCUS (2014) p. 75/76 and 131/132
parent_1 <- c(.12, .09, .05, .03, "nd", "nd", "nd", "nd", "nd", "nd")
set_nd_nq(parent_1, 0.02)
parent_2 <- c(.12, .09, .05, .03, "nd", "nd", .03, "nd", "nd", "nd")
set_nd_nq(parent_2, 0.02)
set_nd_nq_focus(parent_2, 0.02, loq = 0.05)
parent_3 <- c(.12, .09, .05, .03, "nd", "nd", .06, "nd", "nd", "nd")
set_nd_nq(parent_3, 0.02)
set_nd_nq_focus(parent_3, 0.02, loq = 0.05)
metabolite <- c("nd", "nd", "nd", 0.03, 0.06, 0.10, 0.11, 0.10, 0.09, 0.05, 0.03, "nd", "nd")
set_nd_nq(metabolite, 0.02)
set_nd_nq_focus(metabolite, 0.02, 0.05)
#
# Boesten et al. (2015), p. 57/58
table_8 <- matrix(
  c(10, 10, rep("nd", 4),
    10, 10, rep("nq", 2), rep("nd", 2),
    10, 10, 10, "nq", "nd", "nd",
    "nq", 10, "nq", rep("nd", 3),
    "nd", "nq", "nq", rep("nd", 3),
    rep("nd", 6), rep("nd", 6)),
  ncol = 6, byrow = TRUE)
set_nd_nq(table_8, 0.5, 1.5, time_zero_presence = TRUE)
table_10 <- matrix(
  c(10, 10, rep("nd", 4),
    10, 10, rep("nd", 4),
    10, 10, 10, rep("nd", 3),
    "nd", 10, rep("nd", 4),
    rep("nd", 18)),
  ncol = 6, byrow = TRUE)
set_nd_nq(table_10, 0.5, time_zero_presence = TRUE)
}
\references{
Boesten, J. J. T. I., van der Linden, A. M. A., Beltman, W. H.
J. and Pol, J. W. (2015). Leaching of plant protection products and their
transformation products; Proposals for improving the assessment of leaching
to groundwater in the Netherlands — Version 2. Alterra report 2630, Alterra
Wageningen UR (University & Research centre)

FOCUS (2014) Generic Guidance for Estimating Persistence and Degradation
Kinetics from Environmental Fate Studies on Pesticides in EU Registration, Version 1.1,
18 December 2014, p. 251
}
