% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixgb.R
\name{default_params}
\alias{default_params}
\title{Auxiliary function for validating xgb.params}
\usage{
default_params(
  device = "cpu",
  tree_method = "hist",
  eta = 0.3,
  gamma = 0,
  max_depth = 3,
  min_child_weight = 1,
  max_delta_step = 0,
  subsample = 0.7,
  sampling_method = "uniform",
  colsample_bytree = 1,
  colsample_bylevel = 1,
  colsample_bynode = 1,
  lambda = 1,
  alpha = 0,
  max_leaves = 0,
  max_bin = 256,
  num_parallel_tree = 1,
  nthread = -1
)
}
\arguments{
\item{device}{Can be either \code{"cpu"} or \code{"cuda"}. For other options please refer to \href{https://xgboost.readthedocs.io/en/stable/parameter.html#general-parameters}{XGBoost documentation on parameters}.}

\item{tree_method}{Options: \code{"auto"}, \code{"exact"}, \code{"approx"}, and \code{"hist"}. Default: \code{"hist"}.}

\item{eta}{Step size shrinkage. Default: 0.3.}

\item{gamma}{Minimum loss reduction required to make a further partition on a leaf node of the tree. Default: 0}

\item{max_depth}{Maximum depth of a tree. Default: 3.}

\item{min_child_weight}{Minimum sum of instance weight needed in a child. Default: 1.}

\item{max_delta_step}{Maximum delta step. Default: 0.}

\item{subsample}{Subsampling ratio of the data. Default: 0.7.}

\item{sampling_method}{The method used to sample the data. Default: \code{"uniform"}.}

\item{colsample_bytree}{Subsampling ratio of columns when constructing each tree. Default: 1.}

\item{colsample_bylevel}{Subsampling ratio of columns for each level. Default: 1.}

\item{colsample_bynode}{Subsampling ratio of columns for each node. Default: 1.}

\item{lambda}{L2 regularization term on weights. Default: 1.}

\item{alpha}{L1 regularization term on weights. Default: 0.}

\item{max_leaves}{Maximum number of nodes to be added (Not used when \code{tree_method = "exact"}). Default: 0.}

\item{max_bin}{Maximum number of discrete bins to bucket continuous features (Only used when \code{tree_method} is either \code{"hist"}, \code{"approx"} or \code{"gpu_hist"}). Default: 256.}

\item{num_parallel_tree}{The number of parallel trees used for boosted random forests. Default: 1.}

\item{nthread}{The number of CPU threads to be used. Default: -1 (all available threads).}
}
\value{
A list of hyperparameters.
}
\description{
Auxiliary function for setting up the default XGBoost-related hyperparameters for mixgb and checking the \code{xgb.params} argument in \code{mixgb()}. For more details on XGBoost hyperparameters, please refer to \href{https://xgboost.readthedocs.io/en/stable/parameter.html}{XGBoost documentation on parameters}.
}
\examples{
default_params()

xgb.params <- list(device = "cuda", subsample = 0.9, nthread = 2)
default_params(device = xgb.params$device,
               subsample = xgb.params$subsample,
               nthread = xgb.params$nthread)

xgb.params <- do.call("default_params", xgb.params)
xgb.params
}
