% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixcure.r
\name{mixcure}
\alias{mixcure}
\title{Mixture cure models}
\usage{
mixcure(
  lformula,
  iformula,
  data,
  lmodel,
  imodel,
  postuncure = NULL,
  emmax = 100,
  eps = 1e-04,
  savedata = FALSE,
  debug = FALSE
)
}
\arguments{
\item{lformula}{a formula specifying the latency model}

\item{iformula}{a formula specifying the incidence model}

\item{data}{a data frame in which to interpret the variables named in the
formulas in lmodel and imodel.}

\item{lmodel}{a list of at least one component: fun,
a text string specifying R function to fit the latency model. Other arguments to the
function specified in fun can be added to the list. If lmodel is not supplied,
the default is lmodel = list(fun = "coxph")
and it fits the semiparametric PH latency model to the data. Other latency
models currently implemented include
\itemize{
\item fun = "survfit" (for nonparametric mixture cure models),
\item fun = "survreg"  (for parametric mixture cure models),
\item fun = "flexsurvreg"  (for parametric mixture cure models),
\item fun = "flexsurvspline" (for parametric mixture cure models),
\item fun = "cox.aalen" (for semiparametric multiplicative-additive hazards
models),
\item fun = "prop.odds" (for semiparametric proportional odds models).}
R functions for other regression models for
survival data can be added as long as they meet certain criteria. See
details on how a new regression model for survival data can be added.}

\item{imodel}{a list of at least one component: fun,
a text string specifying the R function to fit the incidence model.
Other arguments to the
function specified in fun can be added to the list. If imodel is not supplied,
the default is imodel = list(fun = "glm",
family = binomial()) and it fits the logistic regression as the
incidence model to the data. The other incidence model currently implemented is
fun = "gam".
R functions for other regression models as the incidence model can be added
as long as they meet certain criteria. See details on how a new regression model
for incidence model can be added.

A covariate
may be used in both lformula and iformula. A model with the intercept
term only in iformula assumes that there are cured patients and that the cure
rates are the same for all patients.}

\item{postuncure}{a vector of initial probabilities of being uncured for all
subjects}

\item{emmax}{the maximum number of EM iterations}

\item{eps}{tolerance for EM convergence. Iteration stops once the relative
change in log likelihoods is less than eps.}

\item{savedata}{If TRUE, the data set will be stored in the final object. It
is mainly used for bootstrap in \code{summary()} to get standard errors. Default is FALSE.}

\item{debug}{for debug purpose.}
}
\value{
a list consists of the following components:
\item{ifit}{the final fit from the model for cure probability.}
\item{lfit}{the final fit from the model for failure time of uncured subjects}
\item{survprob}{the final estimate of the survival probability for each subject at its own observed time if uncured}
\item{postuncure}{the final estimate of the posterior uncure probability for each subject based its observed values. The prior uncure probability can be obtained from ifit$uncureprob}
\item{em}{a matrix containing the iterations of the EM algorithm and
convergence errors (for debug purpose)}
}
\description{
Fit some parametric and semiparametric mixture cure models
}
\details{
This function fits mixture cure models, where the latency and incidence
parts of the mixture cure models can be fit using existing R regression
functions. We implemented the logistic regression and the
generalized additive model for the incidence part and the semiparametric
proportional hazards and additive hazards models and the parametric failure
time models for the latency parts. To include a new regression model xxx()
for the incidence part, you need to add the following functions: \itemize{
\item incidence.xxx() \item coef.incidence.xxx() \item loglik.incidence.xxx()
\item curepred.incidence.xxx() }

To include a new regression model xxx() for the latency part, you need to
add the following functions:
\itemize{
\item latency.xxx()
\item coef.latency.xxx()
\item loglik.latency.xxx()
\item survpred.latency.xxx() }

When mixcure program ends, it may produce warning messages such as "In eval(expr,
envir, enclos) : non-integer #successes in a binomial glm!." The message is
due to the fact that glm is picky when it comes to specifying binomial
models. It warns if it detects that the number of trials or successes is
non-integer, but it still fits the model properly. If you want to suppress
the warning (and you're sure it's not a problem), use family=quasibinomial
instead.

This package requires the following R packages: survival, boot, survey and
any packages that provide the latency and incidence models.
}
\examples{

data(leukaemia)
z = mixcure(Surv(time, cens) ~ transplant, ~ transplant, data = leukaemia)

}
\references{
Peng, Y. and Yu, B. Cure Models: Methods, Applications, and Implementation.
CRC/Chapman & Hall, 2020

Peng, Y. and Taylor, J. M. G. Cure models. In Klein, J.,
van Houwelingen, H., Ibrahim, J. G., and Scheike, T. H., editors, Handbook
of Survival Analysis, Handbooks of Modern Statistical Methods series,
chapter 6, pages 113-134. Chapman & Hall, Boca Raton, FL, USA, 2014

Peng, Y. Fitting semiparametric cure models. Computational Statistics & Data
Analysis, 41: 481-490, 2003
}
\seealso{
summary.mixcure, predict.mixcure, plot.predict.mixcure
}
\author{
Yingwei Peng
}
