% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_r_methods.R
\name{plot_midas_coef}
\alias{plot_midas_coef}
\alias{plot_midas_coef.midas_r}
\title{Plot MIDAS coefficients}
\usage{
plot_midas_coef(x, term_name, title, ...)

\method{plot_midas_coef}{midas_r}(
  x,
  term_name = NULL,
  title = NULL,
  vcov. = sandwich,
  unrestricted = x$unrestricted,
  ...
)
}
\arguments{
\item{x}{\code{midas_r} object}

\item{term_name}{the term name for which the coefficients are plotted. Default is \code{NULL}, which selects the first MIDAS term}

\item{title}{the title string of the graph. The default is \code{NULL} for the default title.}

\item{...}{additional arguments passed to \code{vcov.}}

\item{vcov.}{the covariance matrix to calculate the standard deviation of the cofficients}

\item{unrestricted}{the unrestricted model, the default is unrestricted model from the \code{x} object. Set NULL to plot only the weights.}
}
\value{
a data frame with restricted MIDAS coefficients, unrestricted MIDAS coefficients and lower and upper confidence interval limits. The data
frame is returned invisibly.
}
\description{
Plots MIDAS coefficients of a MIDAS regression for a selected term.
}
\details{
Plots MIDAS coefficients of a selected MIDAS regression term together with corresponding MIDAS coefficients and their confidence intervals
of unrestricted MIDAS regression
}
\examples{
data("USrealgdp")
data("USunempr")

y <- diff(log(USrealgdp))
x <- window(diff(USunempr), start = 1949)
trend <- 1:length(y)

##24 high frequency lags of x included
mr <- midas_r(y ~ trend + fmls(x, 23, 12, nealmon), start = list(x = rep(0, 3)))

plot_midas_coef(mr)
}
\author{
Virmantas Kvedaras, Vaidotas Zemlys
}
