% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.survreg}
\alias{simulate.survreg}
\title{Simulate event times from a survreg object}
\usage{
\method{simulate}{survreg}(object, nsim = 1, seed = NULL, newdata, t0 = NULL, ...)
}
\arguments{
\item{object}{survreg object}

\item{nsim}{number of simulations per row in newdata}

\item{seed}{random number seed}

\item{newdata}{data-frame for defining the covariates for the simulations. Required.}

\item{t0}{delayed entry time. Defaults to NULL (which assumes that t0=0)}

\item{...}{other arguments (not currently used)}
}
\value{
vector of event times with nsim repeats per row in newdata
}
\description{
Simulate event times from a survreg object
}
\examples{
library(survival)
fit <- survreg(Surv(time, status) ~ ph.ecog + age + sex + strata(sex),
               data = lung)
nd = transform(expand.grid(ph.ecog=0:1, sex=1:2), age=60)
simulate(fit, seed=1002, newdata=nd)
simulate(fit, seed=1002, newdata=nd, t0=500)
}
