% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_plates.R
\name{read_plates}
\alias{read_plates}
\alias{read_plate}
\title{Read multiple text files from photometer measurement}
\usage{
read_plates(input_data, pattern = NULL, skip_lines = 2)

read_plate(file_path, skip_lines = 2)
}
\arguments{
\item{input_data}{Either a folder path containing raw data files or a list of data frames.}

\item{pattern}{A character value providing the file pattern to search for. If not provided,
defaults to \code{"^BMA|bma"}.}

\item{skip_lines}{A numerical value that specifies the number of lines to be skipped until data is
provided. These lines will be saved as an attribute and are accessible via the \code{"info"} parameter.
Defaults to 2.}

\item{file_path}{The file path to the file containing the raw data.}
}
\value{
\code{read_plates} returns a list of data frames containing the raw photometer data.

\code{read_plate} returns a data frame containing the raw photometer data
}
\description{
\code{read_plates} reads raw text files generated from photometer measurements of
96-well plates. The data is returned as a list but without additional first lines that are sometimes
used to provide additional information, for example, wavelength used or the date of measurement.
For comparison, this information is saved as an attribute of the list and can be retrieved
via the \code{"info"} parameter.

\code{read_plate} reads a raw text file generated from a photometer measurement of a
96-well plate. The data is returned as is but without additional first lines that are sometimes
used to provide additional information, for example, wavelength used or the date of measurement.
For comparison, this information is saved as an attribute of the raw data and can be retrieved
via the \code{"info"} parameter.
}
