% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootfunctions.R
\name{plotpboot}
\alias{plotpboot}
\title{Quantile plots for p value distributions.}
\usage{
plotpboot(porder)
}
\arguments{
\item{porder}{Matrix feeds from pboot. This is a matrix of p values from the bootstrap sampls. Of size Bxm, each row for one bootstrap. The columns indicate the coordinates for testing.}
}
\value{
ggplot2 object contatining the plot.
}
\description{
Produces density plots of quantiles of transformed order statistics of p values
}
\details{
Plot function for pboot

This function plots the order statistics of the quantiles of the transformed p values. As the distribution of the statistic changes as the number of coordinates increase, it should show a change in the curve. 

This function uses ggplot2 and reshape library to manipulate data. The final object returned is a ggplot2 image that can be fed into ggsave or any other supported functions.
}
\examples{
\dontrun{
n = 50;m = 250;m0 = 20;
sigeff = 1;
Sigma <- 0.25*diag(m)
X <- datgen(n,m,m0,sigeff,Sigma = Sigma)
Y <- datgen(n,m,m0,sigeff,Sigma = Sigma)
porder <- pboot.2sample(X=X,Y = Y, B=100,ncpus = 1)
plotpboot(porder)
}
}

