% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deft_do.R
\name{deft_do}
\alias{deft_do}
\title{Implement deft method}
\usage{
deft_do(prepare, group_level, method = "FE")
}
\arguments{
\item{prepare}{a result \code{data.frame} from \link{deft_prepare} function or
a \code{data.frame} contains at least 'trial', 'subgroup', 'yi' and 'sei' these
four columns.}

\item{group_level}{level of subgroup, should be a character vector with
length 2 and the reference should put in the first. For example, if you
have 'Male' and 'Female' groups and want compare 'Female' with 'Male', then
should set \code{c('Male', 'Female')}.}

\item{method}{character string specifying whether a fixed- or a random/mixed-effects model should be fitted. A fixed-effects model (with or without moderators) is fitted when using \code{method="FE"}. Random/mixed-effects models are fitted by setting \code{method} equal to one of the following: \code{"DL"}, \code{"HE"}, \code{"SJ"}, \code{"ML"}, \code{"REML"}, \code{"EB"}, \code{"HS"}, or \code{"GENQ"}. Default is \code{"REML"}. See \sQuote{Details}.}
}
\value{
a \code{list} which class is 'deft'.
}
\description{
'deft' method is a meta-analytical approach to pool conclusion from multiple
studies. More details please see references.
}
\details{
About model fit, please see \code{\link[metafor:rma]{metafor::rma()}}.
}
\examples{
data("wang2019")
deft_do(wang2019, group_level = c("Male", "Female"))
}
\references{
Fisher, David J., et al. "Meta-analytical methods to identify who
benefits most from treatments: daft, deluded, or deft approach?." bmj 356 (2017): j573.

Wang, Shixiang, et al. "The predictive power of tumor mutational burden
in lung cancer immunotherapy response is influenced by patients' sex."
International journal of cancer (2019).
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
