% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vismetaNetwork.R
\name{vismetaNetwork}
\alias{vismetaNetwork}
\title{vismetaNetwork}
\usage{
vismetaNetwork(
  metanetwork,
  g = NULL,
  beta = 0.1,
  legend = NULL,
  mode = "TL-tsne",
  edge_thrs = NULL,
  layout_metaweb = FALSE,
  nrep_ly = 1,
  flip_coords = FALSE,
  diff_plot_bool = FALSE,
  x_y_range = c(100, 100),
  visNetwork.config = visNetwork.default,
  TL_tsne.config = TL_tsne.default
)
}
\arguments{
\item{metanetwork}{object of class metanetwork}

\item{g}{network (igraph object) to represent, default is metaweb}

\item{beta}{the diffusion parameter of the diffusion kernel, a positive scalar controlling the
vertical squeezing of the network}

\item{legend}{resolution for the legend, legend resolution must be a coarser resolution than the resolution of g, default is NULL}

\item{mode}{mode used for layout, 'TL-tsne' for trophic level t-sne. Default is 'TL-tsne'}

\item{edge_thrs}{if non-null, a numeric (between 0 and 1) indicating an edge threshold for the representation}

\item{layout_metaweb}{a boolean indicating whether the layout of the metaweb should be used to represent the network
to use metaweb layout = T, you need first to compute metaweb layout for this beta value using \code{attach_layout()}}

\item{nrep_ly}{If several layouts for this beta value are attached to the metaweb (if \code{layout_metaweb = T}), index of the layout to use, see \code{attach_layout()}}

\item{flip_coords}{a boolean indicating whether coordinates should be flipped.
In that case, y-axis is the trophic level and x-axis is the layout axis}

\item{diff_plot_bool}{boolean, do not edit by hand}

\item{x_y_range}{a two dimension numeric vector, indicating dilatation of x,y axis}

\item{visNetwork.config}{configuration list for visNetwork representation, default is visNetwork.default}

\item{TL_tsne.config}{configuration list for mode 'TL-tsne', default is TL_tsne.default}
}
\value{
object of class 'visNetwork', dynamic representation of the current network
}
\description{
Function that provides network dynamic representation  (using 'visNetwork') from a
'metanetwork' object with a layout based on a diffusion kernel
}
\examples{
library(metanetwork)
library(igraph)
data("meta_angola")
## Return htmlwidget
# on angola dataset
meta_angola = attach_layout(meta_angola, beta = 0.05)
vismetaNetwork(meta_angola, beta = 0.05)


}
