% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Smith_Hazel.R
\name{plot.sh}
\alias{plot.sh}
\title{Plot the Smith-Hazel index}
\usage{
\method{plot}{sh}(
  x,
  SI = 15,
  radar = TRUE,
  arrange.label = FALSE,
  size.point = 2.5,
  size.line = 0.7,
  size.text = 10,
  col.sel = "red",
  col.nonsel = "black",
  ...
)
}
\arguments{
\item{x}{An object of class \code{sh}}

\item{SI}{An integer (0-100). The selection intensity in percentage of the
total number of genotypes.}

\item{radar}{Logical argument. If true (default) a radar plot is generated
after using \code{coord_polar()}.}

\item{arrange.label}{Logical argument. If \code{TRUE}, the labels are
arranged to avoid text overlapping. This becomes useful when the number of
genotypes is large, say, more than 30.}

\item{size.point}{The size of the point in graphic. Defaults to 2.5.}

\item{size.line}{The size of the line in graphic. Defaults to 0.7.}

\item{size.text}{The size for the text in the plot. Defaults to 10.}

\item{col.sel}{The colour for selected genotypes. Defaults to \code{"red"}.}

\item{col.nonsel}{The colour for nonselected genotypes. Defaults to \code{"black"}.}

\item{...}{Other arguments to be passed from ggplot2::theme().}
}
\value{
An object of class \verb{gg, ggplot}.
}
\description{
Makes a radar plot showing the individual genetic worth for the Smith-Hazel index
}
\examples{
\donttest{
library(metan)
vcov <- covcor_design(data_g, GEN, REP, everything())
means <- as.matrix(vcov$means)
pcov <- vcov$phen_cov
gcov <- vcov$geno_cov

index <- Smith_Hazel(means, pcov = pcov, gcov = gcov, weights = rep(1, 15))
plot(index)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
