% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTSI.R
\name{print.mtsi}
\alias{print.mtsi}
\title{Print an object of class mtsi}
\usage{
\method{print}{mtsi}(x, export = FALSE, file.name = NULL, digits = 4, ...)
}
\arguments{
\item{x}{An object of class \code{mtsi}.}

\item{export}{A logical argument. If \code{TRUE|T}, a *.txt file is exported
to the working directory}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print a \code{mtsi} object in two ways. By default, the results are shown in
the R console. The results can also be exported to the directory.
}
\examples{
\donttest{
library(metan)
# Based on stability only
MTSI_MODEL <- waasb(data_ge,
  resp = c(GY, HM),
  gen = GEN,
  env = ENV,
  rep = REP
)

MTSI_index <- mtsi(MTSI_MODEL)
print(MTSI_index)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
