% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_duration.R
\name{class_duration}
\alias{class_duration}
\alias{new_messyduration}
\alias{messyduration}
\alias{validate_messyduration}
\alias{messyduration.character}
\alias{messyduration.mdate}
\title{A duration class for mdates}
\usage{
new_messyduration(x = character())

messyduration(x, approx_range = 0)

validate_messyduration(x, approx_range = 0)

\method{messyduration}{character}(x, approx_range = 0)

\method{messyduration}{mdate}(x, approx_range = 0)
}
\arguments{
\item{x}{An \code{mdate} variable with ranges.}

\item{approx_range}{Range to expand approximate dates, in days.
If 3, for example, adds 3 days; if -3, removes 3 days from both sides.}
}
\value{
Object of class \code{description}
}
\description{
The \code{mdates_duration} class introduces methods that annotate a duration or
period with representations of its uncertainty.
}
\details{
Most R packages handle duration and periods as exact time or date intervals.
However, this is not possible for 'messy' dates where uncertainty or
approximation might be present.
The \code{mdates_duration} class accounts for uncertainty and approximation
in \code{mdate} objects to return their duration as a range of possible dates.
}
\examples{
messyduration(as_messydate(c("2010-01-01..2010-12-31", "2010-01..2010-12")))
}
