% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_replace.R
\name{state_replace}
\alias{state_replace}
\title{state_replace}
\usage{
state_replace(messy_states, threshold = NA, p = 0)
}
\arguments{
\item{messy_states}{Vector containing the messy state names that will be replaced
by the closest match from \code{state.name}}

\item{threshold}{The maximum distance that will form a match. If this argument
is specified, any element in the messy vector that has no match closer than
the threshold distance will be replaced with NA. Default: NA}

\item{p}{Only used with method "jw", the Jaro-Winkler penatly size. Default: 0}
}
\value{
\code{state_replace()} returns a cleaned version of the bad vector, with each
element replaced by the most similar element of the good vector.
}
\description{
A wrapper function for \code{cat_replace()} that only requires an inputted
vector of messy US state names. \code{state_replace()} uses the built-in character
vector \code{state.name} as the reference clean vector.
}
\details{
State names are often misspelled or abbreviated in datasets, especially datasets that have been
manually digitized or created. \code{state_replace()} is a warpper function of \code{cat_replace()} that quickly solves
this common issue of mispellings or different formats of state names across datasets. This wrapper
function uses a built in clean list of country names \code{state.name} as the reference clean vector and
replaces your inputted messy vector of names to their nearest match in \code{state.name}.
}
\examples{
if(interactive()){
 #EXAMPLE1
 lst <- c("Indianaa", "Wisvconsin", "aLaska", "NewJersey", "Claifoarni")
 fixed <- state_replace(lst)
 }
}
