% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webshot.R
\name{save_webshot}
\alias{save_webshot}
\title{Embedded webshot of leaflet map}
\usage{
save_webshot(
  map,
  path_to_img,
  overwrite = FALSE,
  vwidth = 800,
  vheight = 600,
  cliprect = "viewport",
  ...
)
}
\arguments{
\item{map}{A leaflet map object}

\item{path_to_img}{A path to the image file to save}

\item{overwrite}{Do you want to clobber any existing file?}

\item{vwidth, vheight}{Viewport width and height. This is the width or height
of the virtual browser "window". Chrome expects integer values; numeric
values are rounded to the nearest integer.}

\item{cliprect}{Clipping rectangle. If \code{cliprect} and \code{selector}
are both unspecified, the clipping rectangle will contain the entire page.
This can be the string \code{"viewport"}, in which case the clipping
rectangle matches the viewport size, or it can be a four-element numeric
vector specifying the left, top, width, and height. (Note that the order of
left and top is reversed from the original webshot package.) This option is
not compatible with \code{selector}.

When taking screenshots of multiple URLs, this parameter can also be a list
with same length as \code{url} with each element of the list being
"viewport" or a four-elements numeric vector.}

\item{...}{arguments passed to \code{\link[webshot2:webshot]{webshot2::webshot()}}}
}
\value{
a path to a PNG file
}
\description{
Embedded webshot of leaflet map
}
\examples{
\dontrun{
if (require(leaflet)) {
  map <- leaflet() |>
    addTiles() |>
    addMarkers(lng = 174.768, lat = -36.852, popup = "The birthplace of R")
  save_webshot(map, tempfile())
}
}
}
