% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_mdb}
\alias{read_mdb}
\title{Read a table as data frame}
\usage{
read_mdb(file, table, col_names = TRUE, col_types = NULL, ...)
}
\arguments{
\item{file}{Path to the Microsoft Access file.}

\item{table}{Name of the table, list with \code{mdb_tables()}.}

\item{col_names}{Whether or not to suppress column names from the table.}

\item{col_types}{One of \code{NULL}, a \code{\link[readr:cols]{readr::cols()}} specification, or a string.
See \code{vignette("readr")} for more details. Use \code{TRUE} to create a generic
\code{\link[readr:cols]{readr::cols()}} specification with \code{\link[=mdb_schema]{mdb_schema()}}.}

\item{...}{Additional arguments passed to \code{\link[readr:read_delim]{readr::read_delim()}}.}
}
\value{
A data frame.
}
\description{
Use \code{\link[=export_mdb]{export_mdb()}} to write a table as a temporary CSV file, which is then
read as a data frame using \code{\link[readr:read_delim]{readr::read_delim()}}.
}
\examples{
\dontrun{
read_mdb(mdb_example(), "Airlines")
}
}
