% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcwr.R
\name{mcwr_expectancies}
\alias{mcwr_expectancies}
\title{Calculate expectancies}
\usage{
mcwr_expectancies(data, initprop = NULL, vllmap = NULL, ...)
}
\arguments{
\item{data}{an mcwr data.frame}

\item{initprop}{a numeric vector. It supplies information about the initial state fractions at baseline age.
Its elements must be in the interval [0 1] and sum to 1.
It must have element names corresponding to all from-states in the model, in ascending order.
For example, If your model contains from-states 1, 2, and 7,
initspec must be a 3-element numeric vector, specifying the initial proportion of each state in turn.
Its names attribute must consist of the sequential from-states ('1 2 7' in the above example).}

\item{vllmap}{a numeric vector.
Its elements must have the from-states of the model as a subset.
If elements of the vector have names, they are used in labelling output.}

\item{...}{options \code{timing}, \code{add}, and \code{replace}. See \code{\link{mcwr_genvars}}.\cr\cr
In most cases, you do not have to create a full set of r-variables using function \code{mcwr_genvars()}.
r-variables that correspond to timings that can be accommodated by the \code{timing} option can be created
automatically, behind the scenes.  You do so by specifying the \code{timing} option in function
expectancies instead in the function genvars.  Any missing r-variables (and p-variables, for that
matter) will then be created behind the scenes before calculations are done.  They will get deleted
before the function concludes.\cr\cr
r-variables with more complicated timings have to be created explicitly before running function
\code{mcwr_expectancies()}.}
}
\value{
a list of matrices that have been involved in the calculations.
Matrix names are e, P, F, R#.
Matrix e contains the overall results.
}
\description{
Calculate state and overall expectancies. This is the function that does the actual calculations.
}
\seealso{
Other mcwr: 
\code{\link{mcwr_check}()},
\code{\link{mcwr_exit}()},
\code{\link{mcwr_genvars}()},
\code{\link{mcwr_switch}()}
}
\concept{mcwr}
