% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiESS.R
\name{multiESS}
\alias{multiESS}
\title{Effective Sample Size of a multivariate Markov chain as described in Vats et al. (2015)}
\usage{
multiESS(x, covmat = NULL, g = NULL, ...)
}
\arguments{
\item{x}{a matrix or data frame of Markov chain output. Number of rows is the Monte Carlo sample
size.}

\item{covmat}{optional matrix estimate obtained using \code{mcse.multi} or \code{mcse.initseq}.}

\item{g}{a function that represents features of interest. \code{g} is applied to each row of \code{x} and
thus \code{g} should take a vector input only. If \code{g} is \code{NULL}, \code{g} is set to be identity, which
is estimation of the mean of the target density.}

\item{...}{arguments for \code{mcse.multi} function. Don't use this if a suitable matrix estimate
from \code{mcse.multi} or \code{mcse.initseq} is already obtained.}
}
\value{
The function returns the estimated effective sample size.
}
\description{
Calculate the effective sample size of the Markov chain, using the multivariate dependence
structure of the process.
}
\details{
Effective sample size is the size of an iid sample with the same variance as the current sample.
ESS is given by \deqn{ESS = n\frac{|\Lambda|^{1/p}}{|\Sigma|^{1/p}},} where \eqn{\Lambda} is the
sample covariance matrix for \code{g} and \eqn{\Sigma} is an estimate of the Monte Carlo standard
error for \code{g}.
}
\examples{

## Bivariate Normal with mean (mu1, mu2) and covariance sigma
n <- 1e3
mu <- c(2, 50)
sigma <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)
out <- BVN_Gibbs(n, mu, sigma)

multiESS(out)

}
\references{
Vats, D., Flegal, J. M., and, Jones, G. L Multivariate output analysis for Markov chain Monte Carlo, 
\emph{Biometrika}, \bold{106}, 321-337.
}
\seealso{
\code{\link{minESS}}, which calculates the minimum effective samples required for the
problem.
\code{\link{ess}} which calculates univariate effective sample size using a Markov chain and a
function g.
}
