% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNumberOfSpanningTrees.R
\name{getNumberOfSpanningTrees}
\alias{getNumberOfSpanningTrees}
\title{Compute number of spanning trees of a graph}
\usage{
getNumberOfSpanningTrees(graph)
}
\arguments{
\item{graph}{[\code{\link[grapherator]{grapherator}}]\cr
Graph.}
}
\value{
[\code{integer(1)}]
}
\description{
Makes use of Kirchhoff's matrix tree theorem to compute the
number of spanning trees of a given graph in polynomial time.
}
\examples{
# generate complete graph
g = genRandomMCGP(10)

# this is equal to 10^8 (Cayley's theorem)
getNumberOfSpanningTrees(g)
}
