% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.R
\name{estim}
\alias{estim}
\title{Structural change model estimation}
\usage{
estim(m, q, z, y, b, robust, prewhit, hetomega, hetq, x, p, hetdat, hetvar)
}
\arguments{
\item{m}{number of breaks}

\item{q}{number of `z` regressors z}

\item{z}{matrix of regressors with coefficients are allowed to change across
regimes}

\item{y}{matrix of dependent variable}

\item{b}{vector of break dates}

\item{robust, hetomega, hetq, hetdat, hetvar}{options for assumptions on the error terms.
For more details, please refer to \code{\link{mdl}}.}

\item{prewhit}{option to use prewhitening process based on AR(1) approximation}

\item{x}{matrix of regressors with coefficients are constant across regimes}

\item{p}{number of regressors x}
}
\value{
A list containing the following components:
\describe{
\item{date}{List of estimated breaks.}
\item{CI}{List of Confidence Intervals for each corresponding break.}
\item{beta}{Estimated coefficients of the regression. The first
(\code{m}+1)*\code{q} are coefficients of \code{q} variables \code{z} that change across regimes.
The last \code{p} are coefficients of \code{p} variables \code{x}
that are constant across regimes.}
\item{SE}{Corrected standard errors for the coefficients' estimates}}
}
\description{
`estim()` estimates the structural change model by OLS given specified vector of break dates
It also computes and reports confidence intervals for the
break dates based on asymptotic distributions of break date  and
corrected standard errors of coefficients estimates given the structure of covariance matrix
for model errors by specifying error options `robust`, `hetomega`, `hetq`, `hetdat` and `hetvar`
}
